//
//  main.swift
//  StrongReferenceCycleTest
//
//  Created by Jon Hoffman on 6/30/17.
//  Copyright © 2017 Jon Hoffman. All rights reserved.
//

import Foundation

print("Witaj, świecie!")

func testStrongRefCycle() {
    print("----------Klasa Strong-------------")
    var class1: MyClass1_Strong? = MyClass1_Strong(name: "Class1_Strong")
    var class2: MyClass2_Strong? = MyClass2_Strong(name: "Class2_Strong")
    
    class1?.class2 = class2
    class2?.class1 = class1
    
    print("Przypisanie klasom wartości nil")
    class2 = nil
    class1 = nil
}

func testUnwnedRefCycle() {
    print("----------Klasa Unowned-------------")
    let class2 = MyClass2_Unowned(name: "Class2_Unowned")
    let class1: MyClass1_Unowned? = MyClass1_Unowned(name: "class1_Unowned", class2: class2)
    
    class2.class1 = class1
    
    print("Klasy zostały usunięte")
    
}

func testWeakRefCycle() {
    print("----------Klasa Weak-------------")
    let class1: MyClass1_Weak? = MyClass1_Weak(name: "Class1_Weak")
    let class2: MyClass2_Weak? = MyClass2_Weak(name: "Class2_Weak")
    
    class1?.class2 = class2
    class2?.class1 = class1
    
    print("Klasy zostały usunięte")
    
}

testStrongRefCycle()
testUnwnedRefCycle()
testWeakRefCycle()

